/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.pi;

import com.ibm.hsc.cim.provider.pi.IOConcurrentUtils;
import com.ibm.hsc.cim.provider.pi.PIHscProviderConstants;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.PIParseResponse;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.lock.Lock;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt64;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;

public class PIIOConDataTable {
    public static final int EXCHANGE_HYP_PIPE_CAPS_WARNING = 787;
    public static final int NOT_ALL_DATA_RETRIEVED = 1023;
    public static final int UNSUPPORTED_HYP_PIPE_CAPS = 788;
    public static final int EXCHANGE_CAPS_EVENT_ID = 1025;
    public static final int NO_RET_CODE_DATA = 0;
    private String cecName;
    private int eventID;
    private int partID;
    private Vector returnCodeVec;
    private Vector returnLen;
    private Vector returnCodeDataVec;
    private static UnsignedInt64 lparCap = PIHscProviderConstants.IO_CONC_CAP_VALUE;
    private static UnsignedInt64 hmcCMCap = PIHscProviderConstants.IO_CONC_CAP_VALUE;
    private FspCmdHelper cmdHelper;
    private ProviderCIMOMHandle cimHandle;
    private byte[] respData = null;
    private static final int SUCCESS = 0;
    private static final int FAIL = 1;
    private static final String GET_REMAINING_RESP_DATA = "GET_REMAINING_RESP_DATA";

    public PIIOConDataTable(int n, String string, UnsignedInt16 unsignedInt16, ProviderCIMOMHandle providerCIMOMHandle) {
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "-> PIIOConDataTable constructor");
        }
        System.out.println("In the constructor of PIIOConDataTable");
        this.partID = n;
        this.returnCodeVec = new Vector();
        this.returnLen = new Vector();
        this.returnCodeDataVec = new Vector();
        this.cimHandle = providerCIMOMHandle;
        this.cecName = string;
        this.eventID = unsignedInt16.intValue();
        System.out.println("The CEC name is :" + this.cecName);
        OmCecMgr omCecMgr = OmCecMgr.getCecMgr(this.cecName);
        this.cmdHelper = omCecMgr.getCmdHelper();
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "<- PIIOConDataTable constructor");
        }
    }

    public int getPartId() {
        return this.partID;
    }

    public Vector getreturnCodeVec() {
        return this.returnCodeVec;
    }

    public Vector getreturnCodeDataVec() {
        return this.returnCodeDataVec;
    }

    public UnsignedInt64 getLparCap() {
        return lparCap;
    }

    public Vector getreturnLenVec() {
        return this.returnLen;
    }

    public void updateRow(Hashtable hashtable) {
        Hashtable hashtable2;
        boolean bl = true;
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "PIIOConDataTable.updateRow ->");
        }
        System.out.println("In ===========updateRow");
        if (hashtable != null && !(hashtable2 = this.parseResponseData(hashtable)).isEmpty()) {
            System.out.println("WE NEED TO HANDLE REMAINING DATA!!!");
            bl = this.handleRemainingData((UnsignedInt32)hashtable2.get("KEY_ID"));
            if (!bl) {
                this.returnCodeVec.addElement(new UnsignedInt16(1023));
                this.returnLen.addElement(new Integer(0));
            }
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "<- PIIOConDataTable.updateRow ");
        }
    }

    public int ackProcessing(Hashtable hashtable) {
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "PIIOConDataTable.ackProcessing ->");
        }
        System.out.println("in processAck PIIOConDataTable class");
        if (hashtable != null) {
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)hashtable.get("RETURN_CODE");
            if (2 <= Trace.LEVEL) {
                Trace.trace("apcmhscF", "Return Code from ACK resp is:" + unsignedInt16);
            }
            System.out.println("Return Code from ACK resp is:" + unsignedInt16);
            if (!PIHscProviderConstants.IO_CON_MAIN_SUCCESS.equals((Object)unsignedInt16)) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace("apcmhscF", "The ACK is NOT SUCCESSFUL");
                }
                System.out.println("The ACK is not SUCCESSFUL");
                this.returnCodeVec.addElement(unsignedInt16);
                byte[] byArray = (byte[])hashtable.get("RETURN_CODE_DATA");
                this.returnLen.addElement(new Integer(byArray.length));
                if (byArray.length > 0) {
                    IOConcurrentUtils.addToVector(this.returnCodeDataVec, byArray);
                }
                if (2 <= Trace.LEVEL) {
                    Trace.trace("apcmhscF", "<- PIIOConDataTable.ackProcessing");
                }
                return 1;
            }
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "<- PIIOConDataTable.ackProcessing");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Hashtable parseResponseData(Hashtable var1_1) {
        block32: {
            block33: {
                var6_2 = " ";
                var7_3 = new Hashtable<String, Long>();
                var8_4 = false;
                System.out.println("IN parseResponseData =============");
                if (2 <= Trace.LEVEL) {
                    Trace.trace("apcmhscF", "PIIOConDataTable.parseResponseData ->");
                }
                if (var1_1 == null) break block32;
                var2_5 = (UnsignedInt16)var1_1.get("RETURN_CODE");
                if (2 <= Trace.LEVEL) {
                    Trace.trace("apcmhscF", "Hyp Pipe Resp return code value :" + var2_5);
                }
                System.out.println("The Hyper Pipe Resp return code values is :" + var2_5);
                if (!PIHscProviderConstants.IO_CON_MAIN_SUCCESS.equals((Object)var2_5)) break block33;
                var3_6 = ((UnsignedInt32)var1_1.get("LENGTH3")).intValue();
                System.out.println("The length of remaining data is :" + var3_6);
                if (var3_6 > 0L) {
                    var8_4 = true;
                    var5_7 = (UnsignedInt32)var1_1.get("KEY_ID");
                    if (2 <= Trace.LEVEL) {
                        Trace.trace("apcmhscF", "The Key ID  is :" + var5_7);
                    }
                    System.out.println("The Key ID  is :" + var5_7);
                    var7_3.put("LENGTH_OF_DATA", new Long(var3_6));
                    var7_3.put("KEY_ID", (Long)var5_7);
                }
                var9_8 = (byte[])var1_1.get("RESPONSE_DATA");
                if (this.eventID != 1025) {
                    if (var8_4) {
                        System.out.println("tmpRespData len: " + var9_8.length);
                        this.respData = ByteUtilities.byteCat(this.respData, var9_8);
                        System.out.println("now, respData len: " + this.respData.length);
                    } else {
                        var10_10 = ByteUtilities.byteCat(this.respData, var9_8);
                        System.out.println("totalRespData len: " + var10_10.length);
                        try {
                            if (var10_10.length <= 0) ** GOTO lbl140
                            var11_14 = PIParseResponse.parseByCmd("RESP_DATA_STRUCT", var10_10);
                            System.out.println("Resp data hashtable: " + var11_14);
                            var12_18 = (Object[])var11_14.get("IO_CONC_RET_CODE_LIST");
                            for (var13_21 = 0; var13_21 < var12_18.length; ++var13_21) {
                                var14_24 = (Hashtable)var12_18[var13_21];
                                this.returnCodeVec.addElement((UnsignedInt16)var14_24.get("RETURN_CODE"));
                                var15_27 = (byte[])var14_24.get("RETURN_CODE_DATA");
                                this.returnLen.addElement(new Integer(var15_27.length));
                                System.out.println("The length of the byte array returned is + " + var15_27.length);
                                if (var15_27.length <= 0) continue;
                                IOConcurrentUtils.addToVector(this.returnCodeDataVec, var15_27);
                            }
                        }
                        catch (IOException var11_15) {
                            System.out.println("error while parsing resp data...");
                            var11_15.printStackTrace();
                        }
                    }
                } else if (var9_8.length > 0) {
                    try {
                        var10_11 = PIParseResponse.parseByCmd("RESP_DATA_EXCH_CAPS_STRUCT", var9_8);
                        System.out.println("Resp data hashtable: " + var10_11);
                        var11_16 = (UnsignedInt16)var10_11.get("RET_CODE");
                        PIIOConDataTable.lparCap = (UnsignedInt64)var10_11.get("PART_CAPABILITY");
                        System.out.println("LPAR Capabilities: " + PIIOConDataTable.lparCap);
                        if (!PIHscProviderConstants.IO_CON_MAIN_SUCCESS.equals((Object)var11_16)) {
                            this.returnCodeVec.addElement(var11_16);
                        } else {
                            var12_19 = new BigInteger(PIIOConDataTable.lparCap.toString());
                            var13_22 = new BigInteger(PIIOConDataTable.hmcCMCap.toString());
                            System.out.println("hmcCMCap: " + var13_22);
                            System.out.println("lparCMCap: " + var12_19);
                            if (var13_22.intValue() == 0) {
                                this.returnCodeVec.addElement(var11_16);
                            } else {
                                System.out.println("HmcCMCap is not 0!");
                                this.returnCodeVec.addElement(var11_16);
                            }
                        }
                        this.returnLen.addElement(new Integer(0));
                    }
                    catch (IOException var10_12) {
                        System.out.println("error while parsing resp data...");
                        var10_12.printStackTrace();
                    }
                }
                break block32;
            }
            this.returnCodeVec.addElement(var2_5);
            var9_9 = (byte[])var1_1.get("RET_CODE_DATA");
            System.out.println("hi ");
            this.returnLen.addElement(new Integer(var9_9.length));
            if (var9_9.length > 0) {
                var9_9 = (byte[])var1_1.get("RET_CODE_DATA");
                IOConcurrentUtils.addToVector(this.returnCodeDataVec, var9_9);
            }
            if (var2_5.intValue() == 787) {
                if (var9_9.length < 8 || var9_9.length > 8) {
                    System.out.println("Error - number of bytes sent back should be 8!");
                } else {
                    var10_13 = new UnsignedInt64(new BigInteger(var9_9));
                    var11_17 = Lock.getInstance("root/ibmhscS1_0", this.cecName);
                    var12_20 = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscS1_0");
                    var13_23 = String.valueOf(this.partID) + "*" + this.cecName;
                    System.out.println("lparName: " + var13_23);
                    var12_20.addKey("Name", new CIMValue((Object)var13_23));
                    var12_20.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
                    var12_20.setNameSpace("root/ibmhscS1_0");
                    var11_17.lock(1);
                    var14_25 = CimomWrapper.getInstance((CIMOMHandle)this.cimHandle, var12_20, new CIMClass("IBMHSC_Partition"), false);
                    CimomWrapper.setProperty(var14_25, "LparIOConcMaintCap", var10_13);
                    CimomWrapper.setInstance((CIMOMHandle)this.cimHandle, var12_20, var14_25);
                    var17_28 = null;
                    try {
                        var11_17.unlock();
                    }
                    catch (PIHscServerException var18_31) {
                        var18_31.printStackTrace();
                        HSCLogUtils.serverLog(var18_31, HSCLogUtils._CECClassLogInfo);
                    }
                }
                break block32;
                {
                    catch (Throwable var14_26) {
                        if (2 <= Trace.LEVEL) {
                            Trace.trace("apcmhscF", "Error - Can't set part capability in CIMOM!");
                        }
                        System.out.println("Error - Can't set partition cap in CIMOM!");
                        HSCLogUtils.serverLog(var14_26, HSCLogUtils._CECClassLogInfo);
                        var14_26.printStackTrace();
                        var17_29 = null;
                        try {
                            var11_17.unlock();
                        }
                        catch (PIHscServerException var18_32) {
                            var18_32.printStackTrace();
                            HSCLogUtils.serverLog(var18_32, HSCLogUtils._CECClassLogInfo);
                        }
                    }
                }
                catch (Throwable var16_34) {
                    var17_30 = null;
                    try {
                        var11_17.unlock();
                    }
                    catch (PIHscServerException var18_33) {
                        var18_33.printStackTrace();
                        HSCLogUtils.serverLog(var18_33, HSCLogUtils._CECClassLogInfo);
                    }
                    throw var16_34;
                }
            }
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "<- PIIOConDataTable.parseResponseData");
        }
        return var7_3;
    }

    private boolean handleRemainingData(UnsignedInt32 unsignedInt32) {
        Hashtable hashtable = null;
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "-> handleRemainingData");
        }
        System.out.println("In handle RemainingData ===========");
        try {
            hashtable = this.cmdHelper.getRemainingResponseData(unsignedInt32);
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throwable.printStackTrace();
            return false;
        }
        Hashtable hashtable2 = this.parseResponseData(hashtable);
        if (!hashtable2.isEmpty()) {
            this.handleRemainingData((UnsignedInt32)hashtable2.get("KEY_ID"));
        } else if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "<- handleRemainingData");
        }
        return true;
    }

    public void updateCancelRequest() {
        System.out.println("Setting the returnCode vector to FF00");
        this.returnCodeVec.addElement(new CIMValue((Object)new UnsignedInt16(65280)));
        this.returnLen.addElement(new Integer(0));
    }

    static {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream("/opt/hsc/data/hmc.properties"));
            String string = properties.getProperty("HmcConcMaintCaps");
            System.out.println("The conc maint capabilities value is: " + string);
            if (string != null) {
                lparCap = new UnsignedInt64(string);
                hmcCMCap = new UnsignedInt64(string);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

